@extends('layouts.master')
@section('title', __('Cookie Setting'))
@section('breadcum')
<div class="breadcrumbbar">
  <h4 class="page-title">{{ __('Cookie Settings') }}</h4>
  <div class="breadcrumb-list">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{url('/admin')}}" title="{{ __('Dashboard') }}">{{ __('Dashboard') }}</a>
      </li>
      <li class="breadcrumb-item active" aria-current="page">{{ __('Cookie Settings') }}</li>
    </ol>
  </div>
</div>
@endsection
@section('maincontent')
<div class="contentbar">
  <div class="row">
    <div class="col-lg-12">
      <div class="card m-b-30">
        <div class="card-header">
          <h5 class="box-title">{{ __('CookieSettings') }}</h5>
        </div>
        <div class="card-body ml-2">
          <form method="POST" action="{{ route('config.cookieupdate') }}">
            @csrf
            <div class="row">
              <div class="col-lg-4 col-md-4">
                <div class="row">
                  <div class="col-lg-4 col-md-3 col-4">
                    <div class="form-group mb-3">
                      <label for="customSwitch" class="form-check-label">{{ __('Cookie Notice') }}</label>
                      <div class="form-switch mt-1">
                        <input class="custom_toggle form-check-input" type="checkbox" name="cookie_enable" id="customSwitch"
                          value="1" {{ $config->cookie_enable == '1' ? 'checked' : '' }} />
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-8 col-md-9 col-8" id="additionalInputBox"
                    style="{{ $config->cookie_enable == '1' ? '' : 'display:none' }}">
                    <div class="form-group mb-3">
                      <label for="cookienotice" class="form-check-label">{{ __('Cookie Notice Message') }}
                        <span class="text-danger align-middle">*</span>
                      </label>
                      <input type="text" name="cookie_msg" value="{{ $config->cookie_msg }}"
                        placeholder="Enter Cookie Notice Message" id="cookienotice" class="form-control">
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-12">
                <div class="form-group table-btn mt-4">
                  <button type="reset" class="btn btn-secondary" title="{{ __('Reset') }}">
                    <i class="flaticon-ban-circle-symbol"></i>{{ __('Reset') }}
                  </button>
                  <button type="submit" class="btn btn-primary" title="{{ __('Update') }}">
                    <i class="flaticon-check-mark"></i>{{ __('Update') }}
                  </button>
                </div>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>

          @endsection
          @section('script')
          <script>
            function toggleInputBoxes() {
              var checkbox = document.getElementById('customSwitch');
              var additionalInputBox = document.getElementById('additionalInputBox');
              additionalInputBox.style.display = checkbox.checked ? '' : 'none';
            }
            document.getElementById('customSwitch').addEventListener('change', toggleInputBoxes);
            toggleInputBoxes();
          </script>
          @endsection